// express 설정 파일
import express from "express";
import cors from "cors";
import { Server } from "socket.io";
import http from "http";
import wrtc from "wrtc";
import cookieParser from "cookie-parser";
import mainRouter from "./routes/index.js";

const app = express();
app.use(cors());
const server = http.createServer(app);
const io = new Server(server, {
  cors: {
    origin: "http://localhost:3000",
    methods: ["GET", "POST"],
    allowedHeaders: ["my-custom-header"],
    credentials: true,
  },
});
app.use(express.json());
app.use(express.urlencoded({ extended: true }));
app.use(cookieParser());

app.use("/api", mainRouter);

io.on("connection", (socket) => {
  console.log("a user connected");

  socket.on("connected", (data) => {
    console.log(data);
  });
  socket.emit("toclient", { msg: "안녕하세요" });
});

export default server;
