import React, { useState } from "react";
import io from "socket.io-client";
import { useRef } from "react";
import { useEffect } from "react";
import Video from "./Video";
import { useParams } from "react-router-dom";

const Screen = () => {
  const [socket, setSocket] = useState(null);
  const [users, setUsers] = useState([]);
  const { roomId, channelId } = useParams();

  const user = "00";
  let localVideoRef = useRef(null);

  useEffect(() => {
    let newSocket = io("http://localhost:8080", {
      withCredentials: true,
      extraHeaders: {
        "my-custom-header": "abcd"
      }
    });
    console.log(newSocket);

    newSocket.emit("connected", "채린이");
    newSocket.on("toclient", (data) => {
      console.log(data.msg);
    });

  }, []);

  return (
    <div className="container">
      <div className="mt-3" style={{ backgroundColor: "#FCF4FF" }}>
        <div
          className="m-2 d-flex fw-bold text-center"
          style={{ color: "#4A4251", fontSize: "20px" }}
        >
          <img
            className="rounded-circle me-2"
            src="/cherry.jpg"
            width="40px"
            height="40px"
          />
          {user}님이 화면공유중...
        </div>
        <video
          style={{
            display: "flex",
            justifyContent: "center",
            width: 375,
            height: 260,
            backgroundColor: "black",
          }}
          muted
          ref={localVideoRef}
          autoPlay
        />
      </div>
    </div>
  );
};

export default Screen;
