import { Link, useParams } from 'react-router-dom'

const ChannelSingle = (props) => {
  const { roomId, channelId } = useParams()
  console.log('props', props.channel)
  console.log('hi', channelId)
  return (
    <div>
      <div className="overflow-auto" style={{ height: '610px' }}>
        {props.channel.map((el,i) => (
          <div className="mb-3" key={`channel${i}`}>
            <Link to={`/room/${roomId}/${el.channelName}`}>
              <div
                className="m-3 p-1 row"
                style={{ backgroundColor: '#E0CEE8' }}
              >
                {el.channelName === channelId ? (
                  <img
                    className="col-auto mt-2"
                    src="/fullSpeaker.png"
                    width="25px"
                    height="25px"
                  />
                ) : (
                  <img
                    className="col-auto mt-2"
                    src="/emptySpeaker.png"
                    width="25px"
                    height="25px"
                  />
                )}
                <h5 className="col mt-2" style={{ color: 'black' }}>
                  {el.channelName}
                </h5>
              </div>
            </Link>

            {el.joinName &&
              el.joinName.map((e,i) => (
                <div key={`member${i}`}>
                  <ul className="mx-5" style={{ color: '#76D079' }}>
                    <li>
                      <p style={{ color: 'black' }}>{e}</p>
                    </li>
                  </ul>
                </div>
              ))}
          </div>
        ))}
      </div>
    </div>
  )
}

export default ChannelSingle