import { Sequelize } from "sequelize";
import UserModel from "./user.model.js";
import RoomModel from "./room.model.js";

const env = process.env.NODE_ENV || "development";
import configs from "../config/config.js";
const config = configs[env];

const sequelize = new Sequelize(
  config.database,
  config.username,
  config.password,
  { host: config.host, dialect: config.dialect }
);

const User = UserModel(sequelize);
const Room = RoomModel(sequelize);

export { sequelize, User, Room };
