import { Link, useParams } from "react-router-dom";
import { useState, useEffect } from "react";
import userApi from "../../apis/user.api";


const userprofile = localStorage.getItem("user");
const INIT_PROFILE = {
  img:"",
};

const Profile = () => {
  
  const [profile, setProfile] = useState(INIT_PROFILE);

  async function getProfile(userID) {
    try {
      const data = await userApi.getUser({id:userID});
      setProfile(data.img)
      
    } catch (error) {}
  }
  useEffect(() => {
    getProfile(userprofile);
  }, [userprofile]);


  const { id } = useParams();
  
  return (
    <div className="container" style={{ background: "#FCF4FF" }}>
      <>
        <div className="row">
          <form>
            <label
              className="form-label mx-2 my-4"
              style={{ fontSize: "18px", fontWeight: "bold" }}
            >
              프로필 정보
            </label>
            <Link to={`/profile/${id}/update`}>
              <button
                type="button"
                className="btn btn-outline-white "
                style={{
                  background: "#d4cafb",
                  fontSize: "13px",
                  fontWeight: "bold",
                }}
              >
                수정
              </button>
            </Link>
          </form>
          <div className="col"></div>
          <div className="col">
            <div className="d-flex justify-content-center">
              <img
                src={`/uploads/${profile}`}
                className="rounded-circle mt-2"
                style={{ height: "320px", width: "320px" }}
              />
            </div>
          </div>
          <div className="col"></div>
        </div>
      </>
    </div>
  );
};

export default Profile;
