import userApi from "../../apis/user.api";
import { useEffect, useState } from "react";

const userprofile = localStorage.getItem("user");
const INIT_PROFILE = {
  name: "",
  email: "a",
  id: "",
  phone: "",
};

const Info = () => {
  const [profile, setProfile] = useState(INIT_PROFILE);

  async function getProfile(userID) {
    try {
      const data = await userApi.getUser({id:userID});
      setProfile(data);
    } catch (error) {}
  }
  useEffect(() => {
    getProfile(userprofile);
  }, [userprofile]);

  return (
    
    <div className="container" style={{ background: "#FCF4FF" }}>
      
      <div
        className="row justify-content-center  my-4"
        style={{ fontSize: "25px", fontWeight: "bold" }}
      >
        {profile.email} #{profile.id}
      </div>
      <div className="row">
        <div className="col-3"></div>
        <div className="col-6 my-2">
          <h2 className="mb-3" style={{ fontSize: "13px", fontWeight: "bold" }}>
            이름
          </h2>
          <h2
            className="mb-4 mt-2"
            style={{ fontSize: "25px", fontWeight: "bold" }}
          >
            {profile.name}
          </h2>
          <h2
            className="mb-3 mt-2"
            style={{ fontSize: "13px", fontWeight: "bold" }}
          >
            전화번호
          </h2>
          <h2
            className="mb-3 mt-2"
            style={{ fontSize: "25px", fontWeight: "bold" }}
          >
            {profile.phone}
          </h2>
        </div>
        <div className="col"></div>
      </div>
    </div>
  );
};

export default Info;
