import CreateRoom from "./CreateRoom";
import JoinRoom from "./JoinRoom";

const AddRoom = () => {
  return (
    <div>
      <div className="mx-4 my-3 d-flex justify-content-between">
        <div className="fs-4">
          참여중인 방목록
        </div>
        <button
          type="button"
          className="py-1 px-2"
          data-bs-toggle="modal"
          data-bs-target="#myModal"
          style={{
            display: "flex",
            flexDirection: "column",
            borderStyle: "solid",
            borderRadius: "5px",
            backgroundColor: "#E0CEE8",
            borderColor: "#E0CEE8",
          }}
        >
          추가
        </button>
      </div>

      <div className="modal" id="myModal" tabIndex="-1" aria-hidden="true">
        <div className="modal-dialog">
          <div className="modal-content">
            <div className="modal-header">
              <button
                type="button"
                className="btn-close"
                data-bs-dismiss="modal"
                aria-label="Close"
              ></button>
            </div>
            <div className="modal-body">
              <div className="row justify-content-evenly mt-4 mb-4 fs-6">
                <div className="col-6 d-flex justify-content-center">
                  <button
                    type="button"
                    className="p-3"
                    data-bs-toggle="modal"
                    data-bs-target="#joinModal"
                    // data-bs-dismiss="modal"
                    style={{
                      display: "flex",
                      flexDirection: "column",
                      borderStyle: "solid",
                      borderRadius: "5px",
                      backgroundColor: "#E0CEE8",
                      borderColor: "#E0CEE8",
                    }}
                  >방참여하기
                  </button>
                  <div
                    className="modal fade"
                    id="joinModal"
                    tabIndex="-1"
                    aria-labelledby="joinModalLabel"
                    aria-hidden="true"
                  >
                    <div className="modal-dialog">
                      <JoinRoom />
                    </div>
                  </div>
                </div>
                <div className="col-6 d-flex justify-content-center">
                  <button
                    type="button"
                    className="p-3"
                    data-bs-toggle="modal"
                    data-bs-target="#makeModal"
                    // data-bs-dismiss="modal"
                    style={{
                      display: "flex",
                      flexDirection: "column",
                      borderStyle: "solid",
                      borderRadius: "5px",
                      backgroundColor: "#f5cfe3",
                      borderColor: "#f5cfe3",
                    }}
                  >방생성하기
                  </button>
                  <div
                    className="modal fade"
                    id="makeModal"
                    tabIndex="-1"
                    aria-labelledby="makeModalLabel"
                    aria-hidden="true"
                  >
                    <div className="modal-dialog">
                      <CreateRoom />
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default AddRoom;
