import { User } from '../models/index.js'
import jwt from 'jsonwebtoken'
import config from '../config/app.config.js'
import isLength from 'validator/lib/isLength.js'
import bcrypt from "bcryptjs";

const user = async (req, res) => {
  console.log(req.body)
  const user = await User.findAll({ where: { id: req.body } });
  req.json(user)
};

const login = async (req, res) => {
  try {
    console.log('login= ', req.body)
    const { email, password } = req.body
    const user = await User.findOne({ where: { email: email } })
    if (!user) {
      return res.status(422).send(`${email} 사용자가 존재하지 않습니다.`)
    } else {
      const passworMatch = await user.comparePassword(password)
      if (passworMatch) {
        const token = jwt.sign({ userID: user.id }, config.jwtSecret, {
          expiresIn: config.jwtExpires,
        })
        res.cookie(config.cookieName, token, {
          path: '/',
          httpOnly: true,
          secure: true,
        })
        res.json(user)
      } else {
        res.status(401).send('비밀번호가 일치하지 않습니다.')
      }
    }
  } catch (error) {
    console.log(error)
    return res.status(500).send('로그인 중 에러')
  }
}

const signup = async (req, res) => {
  try {
    console.log('sign up= ', req.body)
    const { name, email, password, gender, phone } = req.body
    const id = Math.floor(Math.random() * (9999 - 1000) + 1000)
    console.log('id:', id)
    const Id = await User.findOne({ where: { id: id } })
    console.log('Id 중복확인:', Id)
    while (Id) {
      const id = Math.floor(Math.random() * (9999 - 1000) + 1000)
      const Id = await User.findOne({ where: { id: id } })
    }

    const user = await User.findOne({ where: { email: email } })
    if (user)
      return res.status(422).send(`${email} 이미 존재하는 사용자입니다.`)

    if (!isLength(name, { min: 3, max: 10 })) {
      return res.status(422).send('이름은 3-10자 사이입니다')
    } else if (!isLength(password, { min: 6 })) {
      return res.status(422).send('비밀번호는 6자이상 입니다')
    } else if (!isLength(email, { min: 3, max: 10 })) {
      return res.status(422).send('아이디는 3-10자 사이입니다')
    }
    const newUser = await User.create({
      id: id,
      name: name,
      email: email,
      password: password,
      gender: gender,
      phone: phone,
    }).then(_ =>
      console.log('회원가입 정보', id, name, email, password, gender, phone),
    )
  } catch (error) {
    console.log(error)
    return res.status(500).send('회원가입 중 에러')
  }
}

const logout = (req, res) => {
  res.clearCookie('token')
  res.send('Logout Successful')
}

export default {
  user,
  login,
  signup,
  logout,
}
