import { useEffect, useState } from 'react';
import { Link } from 'react-router-dom'
import userApi from '../../apis/user.api';


const RoomSingle = () => {
  const [room, setRoom] = useState('')
  const id = localStorage.getItem('user');
  const channelId = 1

  async function getRoom(id) {
    try {
      const Room = await userApi.getUser(id)
      setRoom(Room.data.roomNumber)
    } catch (error) {
      // catchErrors(error, setError)
    }
  }

  useEffect(() => {
    getRoom(id)
  }, [id])

  return (
    <Link
      to={`/room/${id}/${channelId}`}
      className="text-decoration-none text-dark"
    >
      <div
        className="d-flex mx-4 my-2 p-2"
        style={{ backgroundColor: '#C4C4C4' }}
      >
        <div style={{ width: '37px', height: '37px' }}>
          <img
            src="BORA.png"
            className="rounded-circle"
            style={{ width: '37px', height: '37px' }}
          />
        </div>
        <div
          className="mx-3 mt-2"
          style={{
            width: '250px',
            overflow:'scroll',
            whiteSpace: 'nowrap',
            msOverflowStyle:'none',
          }}
        >
          데계 재미있는 수학과 데계데계데계 재미있는 수학과
        </div>
        <div className="ms-auto mt-2"> 15/34 </div>
      </div>

    </Link>
  )
}

export default RoomSingle
