import { Link } from "react-router-dom";
import { useState, useEffect } from "react";
import userApi from "../../apis/user.api";

const INIT_USER = {
  id: '',
  name: '',
  img: '',
}

const HomeProfile = () => {
  const [user, setUser] = useState(INIT_USER)

  const id = localStorage.getItem('user');

  async function getUser(id) {
    try {
      // `/users/${userId}`랑 userId랑 같은지 확인
      const User = await userApi.getUser(id)
      console.log(User)
      setUser(User.data)
      console.log(user)
    } catch (error) {
      // catchErrors(error, setError)
    }
  }

  useEffect(() => {
    getUser(id)
  }, [id])

  return (
    <Link to={`/profile/${id}`} className="text-decoration-none text-dark">
      <form className="flex-column align-items-center justify-content-center m-2">
        <div className="d-flex justify-content-center">
          <img
            // src="cherry.jpg"
            className="rounded-circle"
            style={{
              width: "157px",
              height: "157px",
            }}
            value={user.img}
          />
        </div>
        <h1 className="d-flex justify-content-center"> {user.name} </h1>
        <h2 className="d-flex justify-content-center"> #{user.id} </h2>
      </form>
      <div
        style={{ backgroundColor: "#262626", width: "auto", height: "2px" }}
      />
    </Link>
  );
};

export default HomeProfile;
