import ChannelSingle from "./ChannelSingle";
import catchErrors from "../../context/catchError";
import roomApi from "../../apis/room.api";
import { useState, useEffect } from "react";
import { useParams } from "react-router-dom";

const userId = localStorage.getItem('user');
const INIT_ROOM = {
    name: '',
    owner: userId,
    member: userId,
    profileimg: '',
}

const INIT_CHANNEL = {
    channelName: "",
    joinName: [],
};

const LeftHamberger = () => {
    const [channel, setChannel] = useState([INIT_CHANNEL]);
    const { roomId } = useParams();
    const [error, setError] = useState("");

    async function getChannel(roomId) {
        // console.log('roomId', roomId)
        const ID = roomId
        try {
            const data = await roomApi.getRoom([ID]);
            const Channel = data[0].channel
            // console.log('방데이터:', Channel[0])
            const channelList = [];
            for (const prop in Channel) { // Channel의 항목(prop)으로 작업을 실행합니다
                for (const key in Channel[prop]) {
                    // console.log(key)
                    // console.log(prop)
                    // console.log(Channel[prop][key])
                    channelList.push({
                        channelName: key,
                        joinName: Channel[prop][key]
                    });
                }
            }
            setChannel(channelList);
        } catch (error) {
            catchErrors(error, setError);
        }
    }
    // console.log(channel)

    useEffect(() => {
        // console.log('roomId', roomId)
        getChannel(roomId);
    }, [roomId]);

    function roomIdCopy() {
        const t = document.querySelector("#roomId").innerText;
        console.log(t);
        navigator.clipboard.writeText(t);
        document.execCommand("copy");
    }
    return (
        <div>
            <div>
                <button
                    className="navbar-toggler"
                    type="button"
                    data-bs-toggle="offcanvas"
                    data-bs-target="#left-hamburger"
                    aria-controls="left-hamburger"
                    aria-expanded="false"
                    aria-label="Toggle navigation"
                    style={{ border: "#f4c1f2" }}
                >
                    <span className="navbar-toggler-icon"></span>
                </button>
            </div>

            <div
                className="offcanvas offcanvas-start"
                style={{ width: "330px" }}
                tabIndex="-1"
                id="left-hamburger"
                aria-labelledby="hamburgerLabel"
            >
                <div className="offcanvas-header">
                    <p
                        className="col-6 offcanvas-title"
                        id="offcanvasExampleLabel"
                        style={{
                            fontWeight: "bold",
                            fontSize: "15px",
                            width: "150px",
                            color: "#000000",
                        }}
                    >
                        온/오프라인 사용자
                    </p>
                    <h6 className="mt-2" id="roomId">
                        {" "}
                        {" "}
                    </h6>
                    <button
                        type="button"
                        className="btn-close text-reset"
                        data-bs-dismiss="offcanvas"
                        aria-label="Close"
                    ></button>
                </div>
                <div className="overflow-auto" style={{ height: "610px" }}>
                    <div className="mb-3">
                        <div className="m-3 p-1 row" style={{ backgroundColor: "#E0CEE8" }}>
                            <h5 className="col mt-2">온라인 사용자</h5>
                        </div>
                        {channel.map((el) => (
                            <div>
                                {el.joinName && el.joinName.map((e) => (
                                        <ul className="mx-5" style={{ color: "#76D079" }}>
                                            <li>
                                                <p style={{ color: "black" }}>{e}</p>
                                            </li>
                                        </ul>
                                    ))}
                            </div>
                        ))}
                    </div>

                    <div className="mb-3">
                        <div className="m-3 p-1 row" style={{ backgroundColor: "#E0CEE8" }}>
                            <h5 className="col mt-2">오프라인 사용자</h5>
                        </div>
                        <ul className="mx-5">
                            <li>CHERRY</li>
                            <li>JAEYEON</li>
                            <li>SEOYEON</li>
                            <li>JIWEON</li>
                            <li>BYOUNGYUN</li>
                        </ul>
                    </div>
                </div>

                <div>
                    <div className="d-flex flex-row-reverse">
                        <button
                            type="button"
                            className="m-3 rounded"
                            data-bs-toggle="modal"
                            data-bs-target="#inviteRoom"
                            style={{
                                height: "30px",
                                fontWeight: "bold",
                                backgroundColor: "#E0CEE8",
                                color: "black",
                                border: "1px #D64D61",
                            }}
                        >
                            초대
                        </button>
                        <div
                            className="modal fade"
                            id="inviteRoom"
                            tabIndex="-1"
                            aria-labelledby="exitRoomLabel"
                            aria-hidden="true"
                        >
                            <div className="modal-dialog">
                                <div className="modal-content">
                                    <div className="modal-header">
                                        <button
                                            type="button"
                                            className="btn-close"
                                            data-bs-dismiss="modal"
                                            aria-label="Close"
                                        ></button>
                                    </div>
                                    <div className="modal-body d-flex justify-content-center">
                                        어떤 방식으로 초대하시겠습니까?
                                    </div>
                                    <div className="row mb-3">
                                        <div className="d-flex justify-content-evenly">
                                            <button
                                                type="submit"
                                                className="col-2 p-1 btn btn-primary"
                                                style={{ width: "120px" }}
                                            >
                                                카카오로 초대
                                            </button>
                                            {/*
                                            <button
                                                type="submit"
                                                className="col-2 p-1 btn btn-primary"
                                                data-bs-toggle="modal"
                                                data-bs-target="#copyRoomId"
                                                onClick={roomIdCopy}
                                                style={{ width: "120px" }}
                                            >
                                                방 Id 복사
</button> */}
                                            <button
                                                type="submit"
                                                className="col-2 p-1 btn btn-primary"
                                                data-bs-dismiss="modal"
                                                style={{ width: "120px" }}
                                                onClick={roomIdCopy}
                                            >
                                                방 Id 복사
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    );
};

export default LeftHamberger;
