import React, { useEffect } from "react";

const KakaoShareButton = () => {
  useEffect(() => {
    createKakaoButton();
  }, []);
  const ad = "이름"
  const createKakaoButton = () => {
    // kakao sdk script이 정상적으로 불러와졌으면 window.Kakao로 접근이 가능합니다
    if (window.Kakao) {
      const kakao = window.Kakao;
      // 중복 initialization 방지
      if (!kakao.isInitialized()) {
        // 두번째 step 에서 가져온 javascript key 를 이용하여 initialize
        kakao.init(process.env.REACT_APP_KAKAO_KEY);
      }
      kakao.Link.createDefaultButton({
        container: '#kakao-link-btn',
        objectType: 'text',
        text:
          `${ad}`,
          //'기본 템플릿으로 제공되는 텍스트 템플릿은 텍스트를 최대 200자까지 표시할 수 있습니다. 텍스트 템플릿은 텍스트 영역과 하나의 기본 버튼을 가집니다. 임의의 버튼을 설정할 수도 있습니다. 여러 장의 이미지, 프로필 정보 등 보다 확장된 형태의 카카오링크는 다른 템플릿을 이용해 보낼 수 있습니다.',
        link: {
          mobileWebUrl:
            'http://localhost:3000/room/Invite',
          webUrl:
            'http://localhost:3000/room/Invite',
        },
      });
    }
  };
  return (
    <div className="kakao-share-button">
      {/* Kakao share button */}
      <button 
      id="kakao-link-btn"
      type="submit" 
      className="col-2 p-1 btn btn-primary"
      data-bs-dismiss="modal"
      style={{ width: "120px" }}
      >카카오로 초대
      </button>
    </div>
  );
};
export default KakaoShareButton;
