/**
 * Sample React Native App
 * https://github.com/facebook/react-native
 *
 * @format
 * @flow strict-local
 */

import React, {useEffect, useState} from 'react';
import {SafeAreaView, StyleSheet, Text, View, FlatList} from 'react-native';
import {DEBUG, enablePromise, openDatabase} from 'react-native-sqlite-storage';

DEBUG(true);
enablePromise(true);

const db = openDatabase({
  name: 'TestDB',
  location: 'default',
  createFromLocation: '~TestDB.db', // android/src/main/assets/TestDB.db 파일을 위치 시킴
});

const App = () => {
  const [users, setUsers] = useState([]);

  const populateDatabase = async DB => {
    await DB.transaction(queryUser); // 반드시 (await db)를 해야 프라미스가 성공
  };

  const loadAndQueryDB = async () => {
    try {
      console.log('load and db query ....');
      await populateDatabase(await db);
    } catch (error) {
      console.log(error);
    }
  };

  const closeDatabase = async DB => {
    if (DB) {
      console.log('closing database ...');
      try {
        (await DB).close(
          () => {
            console.log('Database was closed successfully');
          },
          err => console.log(err),
        );
      } catch (error) {
        console.log(error);
      }
    } else {
      console.log('Database was not opened');
    }
  };

  const queryUser = async tx => {
    console.log('Excuting user query');
    try {
      const [txn, results] = await tx.executeSql('SELECT * FROM users');
      console.log('item length', results.rows.length);
      const temp = [];
      for (let i = 0; i < results.rows.length; i++) {
        const element = results.rows.item(i);
        temp.push(element);
        console.log('item ', element);
      }
      setUsers(temp);
    } catch (error) {
      console.log('error in query user', error);
    }
  };

  useEffect(() => {
    loadAndQueryDB();
    return () => {
      // closeDatabase(await db); // 컴포넌트 없어질 때 디비 닫기 Error!!!
    };
  }, []);

  let listViewItemSeparator = () => {
    return (
      <View style={{height: 0.2, width: '100%', backgroundColor: '#808080'}} />
    );
  };

  let listItemView = item => {
    console.log('item in list view', item);
    return (
      <View key={item.name}>
        <Text>Name: {item.name}</Text>
        <Text>Age: {item.age}</Text>
      </View>
    );
  };

  console.log('users', users);
  return (
    <SafeAreaView>
      <Text>Hello</Text>
      <View style={{backgroundColor: 'red'}}>
        <FlatList
          data={users}
          ItemSeparatorComponent={listViewItemSeparator}
          keyExtractor={(item, index) => index.toString()}
          renderItem={({item}) => listItemView(item)}
        />
      </View>
    </SafeAreaView>
  );
};

export default App;
