/**
 * Sample React Native App
 * https://github.com/facebook/react-native
 *
 * @format
 * @flow strict-local
 */

import React, {useEffect, useRef} from 'react';
import {SafeAreaView, StyleSheet, Text} from 'react-native';
import {DEBUG, enablePromise, openDatabase} from 'react-native-sqlite-storage';

DEBUG(true);
enablePromise(true);

const db = openDatabase({
  name: 'TestDB',
  location: 'default',
  createFromLocation: '~TestDB.db',
});

const App = () => {
  const dbRef = useRef(null);

  const populateDatabase = async db => {
    // await db.executeSql('SELECT 1 FROM Version LIMIT 1');
    (await db).transaction(queryUser);
  };

  const loadAndQueryDB = async () => {
    try {
      console.log('load and db query ....');
      // db.transaction(function (txn) {
      //   txn.executeSql(
      //     "SELECT name FROM sqlite_master WHERE type='table' AND name='tbl_user'",
      //     [],
      //     function (tx, res) {
      //       console.log('item:', res.rows.length);
      //       if (res.rows.length == 0) {
      //         txn.executeSql('DROP TABLE IF EXISTS tbl_user', []);
      //         txn.executeSql(
      //           'CREATE TABLE IF NOT EXISTS tbl_user(user_id INTEGER PRIMARY KEY AUTOINCREMENT, user_name VARCHAR(20), user_contact INT(10), user_address VARCHAR(255))',
      //           [],
      //         );
      //       }
      //     },
      //   );
      // });
      // db.transaction(function (tx) {
      //   console.log('transaction started....');
      //   tx.executeSql(
      //     'select * from users',
      //     [],
      //     function (tx, res) {
      //       console.log('item length', res.rows.length);
      //       for (let i = 0; i < res.rows.length; i++) {
      //         const element = res.rows.item(i);
      //         console.log('element=', element);
      //       }
      //     },
      //     function (error) {
      //       console.log(error);
      //     },
      //   );
      // });
      // SQLite.openDatabase({
      //   name: 'TestDB',
      //   location: 'default',
      //   createFromLocation: '~TestDB.db',
      // }).then(db => {
      //   dbRef.current = db;
      //   db.transaction(tx => tx.executeSql('select * from users', []));
      //   // populateDatabase(db);
      // });
      // dbRef.current = db;
      await populateDatabase(db);
    } catch (error) {
      console.log(error);
    }
  };

  const closeDatabase = async db => {
    if (db) {
      console.log('closing database ...');
      try {
        await db.close();
        console.log('Database closed');
      } catch (error) {
        console.log(error);
      }
    } else {
      console.log('Database was not opened');
    }
  };

  const queryUser = async tx => {
    console.log('Excuting user query');
    console.log('tx', tx);
    try {
      const [txn, results] = await tx.executeSql('SELECT * FROM users');
      console.log('item length', results.rows.length);
      for (let i = 0; i < results.rows.length; i++) {
        const element = results.rows.item(i);
        console.log('item ', element);
      }
    } catch (error) {
      console.log('error in query user', error);
    }
  };

  useEffect(() => {
    loadAndQueryDB();
    return () => {
      closeDatabase(db);
    };
  }, []);

  return (
    <SafeAreaView>
      <Text>Hello</Text>
    </SafeAreaView>
  );
};

const styles = StyleSheet.create({
  sectionContainer: {
    marginTop: 32,
    paddingHorizontal: 24,
  },
  sectionTitle: {
    fontSize: 24,
    fontWeight: '600',
  },
  sectionDescription: {
    marginTop: 8,
    fontSize: 18,
    fontWeight: '400',
  },
  highlight: {
    fontWeight: '700',
  },
});

export default App;
